import os 
import csv
from iapws import IAPWS97
import math as m

# The python script uses cfxpost batch mode to get the required values from the inlet and 
# outlet  and then uses the iapws python library to compute 
# the required state h2' (final state for an ideal process, entropy of inlet).

#Adapt paths
resfile = 'NES_Results.res'
cfxpost_path = 'cfx5post'

#STAC specific information
rotational_speed = 50 #s^-1
num_r1 = 41
num_r0 = 45
num_s1 = 39




with open('Eff_NES.cse', 'r') as file:
    lines = file.readlines()

lines[7] = f'  Current Results File = {resfile} \n'

with open('Eff_NES.cse', 'w') as file:
    file.writelines(lines)

os.system(f'{cfxpost_path} -batch Eff_NES.cse')

with open('Eff.csv', mode='r', newline='') as file:
    csv_reader = csv.DictReader(file)
    values_dict = next(csv_reader)

m0_g = float(values_dict['m0 g'])
m0_l = float(values_dict['m0 l'])
m0_tot = m0_l+m0_g

m2_g = float(values_dict['m2 g'])
m2_l = float(values_dict['m2 l'])
m2_tot = m2_l+m2_g


x0= m0_g / m0_tot
x2 = m2_g / m2_tot

p0 = float(values_dict['P0']) / 1000000 # MPa
p2 = float(values_dict['P2']) / 1000000 # MPa

h0_g = float(values_dict['h0 g'])/1000 #kJ/kg
h0_l = float(values_dict['h0 l'])/1000 #kJ/kg
h0 = x0*h0_g +(1-x0)*h0_l

h2_g = float(values_dict['h2 g'])/1000 #kJ/kg
h2_l = float(values_dict['h2 l'])/1000 #kJ/kg  

h2 = x2*h2_g +(1-x2)*h2_l

s0_g = float(values_dict['s0 g'])/1000 #kJ/kgK
s0_l = float(values_dict['s0 l'])/1000 #kJ/kgK
s0 = x0*s0_g +(1-x0)*s0_l

s2_g = float(values_dict['s2 g'])/1000 #kJ/kgK
s2_l = float(values_dict['s2 l'])/1000 #kJ/kgK
s2 = x2*s2_g +(1-x2)*s2_l

c0 = float(values_dict['c0 g']) #m/s
c2 = float(values_dict['c2 g']) #m/s


tq_R0 = float(values_dict['tq r0']) #Nm
tq_R1 = float(values_dict['tq r1']) #Nms


h2_prime = IAPWS97(P = p2, s = s0).h  #assumes equilibrium 

h0_tot = h0 + 0.5*(c0**2)/1000

delta_h_isen = (h0_tot - h2_prime)*1000


mf_tot =(m0_g+m0_l)*num_s1

total_torque = - ( tq_R0*num_r0+ tq_R1*num_r1 )

eta_ss = total_torque*2*m.pi*rotational_speed / (delta_h_isen*mf_tot ) 

print(f'Isentropic Efficency = {eta_ss*100} %')

