import os 
import csv
from iapws import IAPWS97
import math as m

# The python script uses cfxpost batch mode to get the required values from the inlet and 
# outlet  and then uses the iapws python library to compute 
# the required state h2' (final state for an ideal process, entropy of inlet).

#Adapt paths
resfile = 'EQS_Results.res'
cfxpost_path = 'cfx5post'


#STAC specific information
rotational_speed = 50 #s^-1
num_r1 = 41
num_r0 = 45
num_s1 = 39
            
with open('Eff_EQS.cse', 'r') as file:
    # Read all lines into a list
    lines = file.readlines()

lines[7] = f'  Current Results File = {resfile} \n'

with open('Eff_EQS.cse', 'w') as file:
    file.writelines(lines)

os.system(f'{cfxpost_path} -batch Eff_EQS.cse')

with open('Eff.csv', mode='r', newline='') as file:
    csv_reader = csv.DictReader(file)
    values_dict = next(csv_reader)


m2_tot = float(values_dict['mf out'])

x0= float(values_dict['x0'])
x2= float(values_dict['x2'])

p0 = float(values_dict['P0']) / 1000000 # MPa
p2 = float(values_dict['P2']) / 1000000 # MPa

h0 = float(values_dict['h0'])/1000 #kJ/kg
h2 = float(values_dict['h2'])/1000 #kJ/kg


s0 = float(values_dict['s0'])/1000 #kJ/kgK
s2 = float(values_dict['s2'])/1000 #kJ/kgK


c0 = float(values_dict['c0']) #m/s
c2 = float(values_dict['c2']) #m/s

tq_R0 = float(values_dict['tq r0']) #Nm
tq_R1 = float(values_dict['tq r1']) #Nms


h2_prime = IAPWS97(P = p2, s = s0).h  #assumes equilibrium 

h0_tot = h0 + 0.5*(c0**2)/1000

delta_h_isen = (h0_tot - h2_prime)*1000


mf_tot = -m2_tot*num_r0
total_torque = - ( tq_R0*num_r0+ tq_R1*num_r1 )

eta_ss = total_torque*2*m.pi*rotational_speed / (delta_h_isen*mf_tot ) 

print(f'Isentropic Efficency = {eta_ss*100} %')

